import { RefObject } from '@mui/x-internals/types';
import { GridRenderContext } from "../../../models/index.js";
import { GridPrivateApiCommunity } from "../../../models/api/gridApiCommunity.js";
import { DataGridProcessedProps } from "../../../models/props/DataGridProps.js";
import { GridStateInitializer } from "../../utils/useGridInitializeState.js";
type RootProps = Pick<DataGridProcessedProps, 'disableVirtualization' | 'autoHeight'>;
export type GridVirtualizationState = {
  enabled: boolean;
  enabledForColumns: boolean;
  enabledForRows: boolean;
  renderContext: GridRenderContext;
};
export declare const EMPTY_RENDER_CONTEXT: {
  firstRowIndex: number;
  lastRowIndex: number;
  firstColumnIndex: number;
  lastColumnIndex: number;
};
export declare const virtualizationStateInitializer: GridStateInitializer<RootProps>;
export declare function useGridVirtualization(apiRef: RefObject<GridPrivateApiCommunity>, props: RootProps): void;
export {};